<?php
// Simple test script to verify API endpoints

$base_url = 'http://127.0.0.1:8000/api';

echo "Testing Contact API endpoints...\n\n";

// Test 1: Create a contact
echo "1. Testing POST /api/contacts (Create a contact)\n";
$data = array(
    'name' => 'John Doe',
    'number' => '123-456-7890'
);
$payload = json_encode($data);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $base_url . '/contacts');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "Response Code: $http_code\n";
echo "Response: $response\n\n";
$contact_data = json_decode($response, true);
$contact_id = isset($contact_data['data']['id']) ? $contact_data['data']['id'] : null;

// Test 2: Get all contacts
echo "2. Testing GET /api/contacts (Get all contacts)\n";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $base_url . '/contacts');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "Response Code: $http_code\n";
echo "Response: $response\n\n";

// Test 3: Get specific contact
if ($contact_id) {
    echo "3. Testing GET /api/contacts/{$contact_id} (Get specific contact)\n";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $base_url . "/contacts/{$contact_id}");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    echo "Response Code: $http_code\n";
    echo "Response: $response\n\n";
}

// Test 4: Update the contact
if ($contact_id) {
    echo "4. Testing PUT /api/contacts/{$contact_id} (Update contact)\n";
    $update_data = array(
        'name' => 'Jane Doe Updated',
        'number' => '098-765-4321'
    );
    $payload = json_encode($update_data);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $base_url . "/contacts/{$contact_id}");
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    echo "Response Code: $http_code\n";
    echo "Response: $response\n\n";
}

// Test 5: Delete the contact
if ($contact_id) {
    echo "5. Testing DELETE /api/contacts/{$contact_id} (Delete contact)\n";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $base_url . "/contacts/{$contact_id}");
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    echo "Response Code: $http_code\n";
    echo "Response: $response\n\n";
}

echo "API testing completed!\n";